<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>PDF - RAPPORT</title>

    <!-- Fonts -->
    <link href="https://fonts.bunny.net/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet">

    <!-- Styles -->
    <style>
        * {
            font-size: 14.5px !important;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            padding: 0 25px;
        }

        li {
            margin: 3px 0;
        }

        .logo-img {
            display: flex;
            align-items: center;
            justify-content: flex-start;
            /*height: 45px;*/
            width: 100%;
            margin-bottom: 5px;
            border-bottom: 2px solid #000;
            padding: 15px 0;
        }

        .logo-img img {
            width: 30%;
            object-fit: contain;
            height: auto;
        }

        h4 {
            text-align: center;
            margin: 0;
            margin-bottom: 10px;
            padding: 0;
            margin-top: 25px;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        h4 strong {
            text-decoration: underline;
            padding-right: 7px;
        }

        h4 span {
            /*font-size: 18px !important;*/
        }

        .author h2 {
            text-align: center;
            color: #006696 !important;
            margin-bottom: 25px;
        }

        .desc-ctn {
            display: flex;
            align-items: center;
            margin-bottom: 10px;

        }

        .desc-ctn .title {
            font-size: 14px;
            font-weight: bold;
            margin-right: 20px;
        }

        .desc-ctn .desc {
            font-size: 14px;
        }

        .reports {
            padding: 20px 0;
        }

        .content-section {
            margin: 7px 0;
        }

        .content-title {
            text-transform: uppercase;
            color: red
                /***#f80137*/
            ;
            font-weight: bold;
            margin-bottom: 7px;
        }

        .contents {
            text-align: justify;
        }

        ul,
        ol {
            padding: 20px !important;
            padding-top: 0 !important;
            margin-top: 0 !important;
        }

        footer {
            position: fixed;
            bottom: 0px;
            left: 0px;
            right: 0px;
            height: 40px;
            text-align: center;
            line-height: 20px;
            font-size: 10px;
            /** Extra personal styles
              background-color: #0b395b;
              color: white;
              
              line-height: 35px; **/
        }
    </style>
</head>

<body >
    <div class="logo-img">
        <img src="<?php echo e(Vite::asset('resources/images/logo.png')); ?>" alt="akasigroup">
    </div>
    <div style="padding-top: 25px">
        <div style="text-align: left; padding-top: 5px">
            <strong class="title">
                RAPPORT HEBDOMADAIRE
            </strong>
        </div>
        <div style="text-align: left; padding-top: 5px">
            DATE : <span class="desc"> DU <?php echo e(\Carbon\Carbon::now()->startOfWeek()->format('d/m/Y')); ?> AU
                <?php echo e(\Carbon\Carbon::parse($report->updated_at)->format('d/m/Y')); ?> </span>
        </div>
        <div style="left; padding-top: 5px">
            DE : <?php echo e(strtoupper($report->user->firstname)); ?> <?php echo e(strtoupper($report->user->lastname)); ?>


        </div>
    </div>


    <div class="pdf-content">
        <div class="b-container">
            <div class="author">
                
                
            </div>
            <div class="reports">
                <div class="content-section">
                    <div class="content-title">
                        A-) Objectifs de la semaine
                    </div>
                    <div class="contents">
                        <ol>
                            <?php $__currentLoopData = $report->goals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $goal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($goal); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ol>
                    </div>
                </div>
                <div class="content-section">
                    <div class="content-title">
                        B-) Travaux réalisés
                    </div>
                    <div class="contents">
                        <?php $__currentLoopData = $report->achievements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $achievement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div><?php echo e($achievement['title']); ?></div>
                            <ol>
                                <?php $__currentLoopData = $achievement['content']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div>
                                        - <?php echo e($content); ?>

                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ol>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        
                    </div>
                </div>
                <div class="content-section">
                    <div class="content-title">
                        C-) Problèmes à signaler et commentaires généraux
                    </div>
                    <div class="contents">
                        <ol>
                            <?php $__currentLoopData = $report->observations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $observation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div>
                                    - <?php echo e($observation); ?>

                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ol>
                    </div>
                </div>
                <div class="content-section">
                    <div class="content-title">
                        D-) Focus de la semaine suivante
                    </div>
                    <div class="contents">
                        <ol>
                            <?php $__currentLoopData = $report->next_goals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $next_goal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($next_goal); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <footer>
        <p style="text-align:center; font-size:10px;">
            <hr style="width:40%" />
            Rue de l'Église Ste Rita - B.P. 242 Cotonou Republique du Benin www.akasigroup.net Email:
            akasi-admin@akasigroup.com <br />
            Tel : +1 603 852 79 35; +229 67 08 24 29; +225 59 26 40 41; +228 97 78 41 28 +250 78 50 22 308
        </p>
    </footer>

</body>

</html>
<?php /**PATH /var/www/akasi-intranet-backend/resources/views/pdf/report.blade.php ENDPATH**/ ?>