<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>Email - Permission</title>

    <!-- Fonts -->
    <link href="https://fonts.bunny.net/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet">

    <!-- Styles -->

    <style>
        body {
            font-family: 'Nunito', sans-serif;
            overflow-x: hidden;
        }

        * {
            padding: 0;
            margin: 0;
            position: relative;
            box-sizing: border-box;
            box-sizing: border-box;
            color: #343a40;
            /*
            font-size: 18px;
            font-family: Verdana, Geneva, Tahoma, sans-serif; */
        }

        .mail-container {
            min-height: 100vh;
            padding: 20px;
        }

        .b-container {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 100%;
        }

        p{
            margin-top: 10px;
            margin-bottom: 10px;
        }

        .author {
            font-weight: bold;
        }
    </style>
</head>

<body class="antialiased">
    <div class="b-container">
        <div class="mail-container">
            <div class="mail-title">
                <p>
                    Vous aviez reçu une nouvelle demande de permission de la part de
                    <span class="author">
                        <?php echo e($permission->user->firstname); ?> <?php echo e($permission->user->lastname); ?>.
                    </span>
                </p>
                <div>
                    <p>
                        <strong>Objet :</strong> <span> &nbsp; <?php echo e($permission->object); ?></span>
                    </p>
                    <p>
                        <strong>Raison :</strong> <span> &nbsp; <?php echo e($permission->reasons); ?></span>
                    </p>
                    <p>
                        <strong>Date de début :</strong> <span> &nbsp;
                            <?php echo e(\Carbon\Carbon::parse($permission->starting_date)->format('d/m/Y')); ?></span>
                    </p>
                    <p>
                        <strong>Date de fin :</strong> <span> &nbsp;
                            <?php echo e(\Carbon\Carbon::parse($permission->ending_date)->format('d/m/Y')); ?></span>
                    </p>
                    <p>
                        <strong>Durée :</strong> <span> &nbsp; <?php echo e($permission->duration); ?></span>
                    </p>
                    <?php if($permission->piece != null): ?>
                        Vous trouverez en fichier joint la pièce justificative de sa demande
                    <?php endif; ?>
                </div>
            </div>
            <div class="mail-content">

                <div>
                    Veuillez vous connecter sur : <a href="<?php echo e(env('FRONTEND_URL')); ?>">Akasi intranet</a> pour valider ou rejeter la demande.
                </div>
                
            </div>
            <div>

                --
                <p>

                    Cordialement, <br>
                    Akasi Intranet.
                </p>
            </div>
        </div>
    </div>
</body>

</html>
<?php /**PATH /var/www/akasi-intranet-backend/resources/views/emails/permission.blade.php ENDPATH**/ ?>